// Original Ingot Box Author Unknown
// Scripted by Karmageddon and Morgion

using System;
using System.Collections;
using Server;
using Server.Prompts;
using Server.Mobiles;
using Server.ContextMenus;
using Server.Gumps;
using Server.Items;
using Server.Network;
using Server.Targeting;
using Server.Multis;
using Server.Regions;
using Server.Engines.Craft;

namespace Server.Items
{
	[FlipableAttribute( 0xE41, 0xE40, 0xE79, 0xE77, 0x9AA, 0xE7D, 0x9A9, 0xE7E, 0xE3F, 0xE3E, 0xE3D, 0xE3C,
	                   0x9A8, 0xE80, 0x9AB, 0xE7C, 0xe43, 0xe42, 0x280B, 0x280C, 0x280F, 0x2810, 0x2811, 0x2812,
	                   0x2857, 0x2858, 0x2859, 0x285A, 0x285B, 0x285C, 0x285D, 0x285E, 0x2DF1, 0x2DF2, 0x2DF3, 0x2DF4 )]
	public class ToolBox : BaseContainer
	{
		private int m_SmithHammer;
		private int m_Tongs;
		
		private int m_Shovel;
		private int m_Gargoyles;
		private int m_Pickaxe;
		private int m_IngotHammer;
		private int m_Hatchet;
		private int m_Trolls;

		private int m_Plane;
		private int m_BoardPlane;
		
		private int m_TinkerTools;
		
		private int m_ScribesPen;
		private int m_MapmakersPen;
		
		private int m_Sewing;
		
		private int m_MaletChisel;
		private int m_MarbleChisel;
		
		private int m_Fletcher;
		private int m_Mortar;

		private int m_Blowpipe;

		private int m_Skillet;

		[CommandProperty( AccessLevel.GameMaster )]
		public int SmithHammer{ get{ return m_SmithHammer; } set{ m_SmithHammer = value; InvalidateProperties(); } }
		[CommandProperty( AccessLevel.GameMaster )]
      public int Tongs{ get{ return m_Tongs; } set{ m_Tongs = value; InvalidateProperties(); } }
		[CommandProperty( AccessLevel.GameMaster )]
      public int Shovel{ get{ return m_Shovel; } set{ m_Shovel = value; InvalidateProperties(); } }
		[CommandProperty( AccessLevel.GameMaster )]
      public int Gargoyles{ get{ return m_Gargoyles; } set{ m_Gargoyles = value; InvalidateProperties(); } }
		[CommandProperty( AccessLevel.GameMaster )]
      public int Pickaxe{ get{ return m_Pickaxe; } set{ m_Pickaxe = value; InvalidateProperties(); } }
		[CommandProperty( AccessLevel.GameMaster )]
      public int IngotHammer{ get{ return m_IngotHammer; } set{ m_IngotHammer = value; InvalidateProperties(); } }
		[CommandProperty( AccessLevel.GameMaster )]
      public int Hatchet{ get{ return m_Hatchet; } set{ m_Hatchet = value; InvalidateProperties(); } }
		[CommandProperty( AccessLevel.GameMaster )]
      public int Trolls{ get{ return m_Trolls; } set{ m_Trolls = value; InvalidateProperties(); } }
		[CommandProperty( AccessLevel.GameMaster )]
      public int Plane{ get{ return m_Plane; } set{ m_Plane = value; InvalidateProperties(); } }
		[CommandProperty( AccessLevel.GameMaster )]
      public int BoardPlane{ get{ return m_BoardPlane; } set{ m_BoardPlane = value; InvalidateProperties(); } }
		[CommandProperty( AccessLevel.GameMaster )]
      public int TinkerTools{ get{ return m_TinkerTools; } set{ m_TinkerTools = value; InvalidateProperties(); } }
		[CommandProperty( AccessLevel.GameMaster )]
      public int ScribesPen{ get{ return m_ScribesPen; } set{ m_ScribesPen = value; InvalidateProperties(); } }
		[CommandProperty( AccessLevel.GameMaster )]
      public int MapmakersPen{ get{ return m_MapmakersPen; } set{ m_MapmakersPen = value; InvalidateProperties(); } }
		[CommandProperty( AccessLevel.GameMaster )]
      public int Sewing{ get{ return m_Sewing; } set{ m_Sewing = value; InvalidateProperties(); } }
		[CommandProperty( AccessLevel.GameMaster )]
      public int MaletChisel{ get{ return m_MaletChisel; } set{ m_MaletChisel = value; InvalidateProperties(); } }
		[CommandProperty( AccessLevel.GameMaster )]
      public int MarbleChisel{ get{ return m_MarbleChisel; } set{ m_MarbleChisel = value; InvalidateProperties(); } }
		[CommandProperty( AccessLevel.GameMaster )]
      public int Fletcher{ get{ return m_Fletcher; } set{ m_Fletcher = value; InvalidateProperties(); } }
		[CommandProperty( AccessLevel.GameMaster )]
      public int Mortar{ get{ return m_Mortar; } set{ m_Mortar = value; InvalidateProperties(); } }
		[CommandProperty( AccessLevel.GameMaster )]
      public int Blowpipe{ get{ return m_Blowpipe; } set{ m_Blowpipe = value; InvalidateProperties(); } }
		[CommandProperty( AccessLevel.GameMaster )]
      public int Skillet{ get{ return m_Skillet; } set{ m_Skillet = value; InvalidateProperties(); } }

		public override bool DisplaysContent{ get{ return false; } }
		
		[Constructable]
		public ToolBox() : base( 0xE80 )
		{
			Movable = true;
			Weight = 10.0;
			Hue = 1163;
			Name = "Tool Box";
		}
		
		public override void OnDoubleClick( Mobile from )
		{
			if ( !from.InRange( GetWorldLocation(), 2 ) )
				from.LocalOverheadMessage( Network.MessageType.Regular, 0x3B2, 1019045 ); // I can't reach that.
			else if ( from is PlayerMobile )
			{
				if ( !IsSecure )
				{
					from.SendMessage( "Box must be secured in house." );
				}
				else
					from.SendGump( new ToolBoxGump( (PlayerMobile)from, this ) );
			}
		}
		
		public override bool OnDragDrop( Mobile from, Item o )
		{
			if ( !IsSecure )
			{
				from.SendMessage( "Box must be secured in house." );
				return false;
			}
			else if (!( o is BaseTool || o is BaseAxe || o is BaseHarvestTool || o is IngotTransmutationHammer || o is BoardTransmutationPlane ))
			{
				from.SendMessage( "That is not an item you can put in here." );
			}
			else
			{
				//start drag drop
				if ( o is SmithHammer || o is SturdySmithHammer )
				{
					if ( SmithHammer > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						SmithHammer = ( SmithHammer + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						return true;
					}
				}
				if ( o is Tongs )
				{
					if ( Tongs > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Tongs = ( Tongs + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						return true;
					}
				}
				if ( o is Shovel || o is SturdyShovel )
				{
					if ( Shovel > (999999 - ((BaseHarvestTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Shovel = ( Shovel + ((BaseHarvestTool)o).UsesRemaining );
						((Item)o).Delete();
						return true;
					}
				}
				if ( o is GargoylesPickaxe )
				{
					if ( Gargoyles > (999999 - ((BaseAxe)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Gargoyles = ( Gargoyles + ((BaseAxe)o).UsesRemaining );
						((Item)o).Delete();
						return true;
					}
				}
				if ( o is Pickaxe || o is SturdyPickaxe )
				{
					if ( Pickaxe > (999999 - ((BaseAxe)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Pickaxe = ( Pickaxe + ((BaseAxe)o).UsesRemaining );
						((Item)o).Delete();
						return true;
					}
				}
				if ( o is IngotTransmutationHammer )
				{
					if ( IngotHammer > (999999 - ((IngotTransmutationHammer)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						IngotHammer = ( IngotHammer + ((IngotTransmutationHammer)o).UsesRemaining );
						((Item)o).Delete();
						return true;
					}
				}
				if ( o is Hatchet || o is SturdyLumberjackAxe || o is SturdyAxe )
				{
					if ( Hatchet > (999999 - ((BaseAxe)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Hatchet = ( Hatchet + ((BaseAxe)o).UsesRemaining );
						((Item)o).Delete();
						return true;
					}
				}
				if ( o is TrollsHatchet )
				{
					if ( Trolls > (999999 - ((BaseAxe)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Trolls = ( Trolls + ((BaseAxe)o).UsesRemaining );
						((Item)o).Delete();
						return true;
					}
				}
				if ( o is Saw || o is DovetailSaw || o is DrawKnife || o is Froe || o is Hammer || o is Inshave || o is JointingPlane
                || o is MouldingPlane || o is Nails || o is Scorp )
				{
					if ( Plane > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Plane = ( Plane + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						return true;
					}
				}
				if ( o is BoardTransmutationPlane )
				{
					if ( BoardPlane > (999999 - ((BoardTransmutationPlane)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						BoardPlane = ( BoardPlane + ((BoardTransmutationPlane)o).UsesRemaining );
						((Item)o).Delete();
						return true;
					}
				}
				if ( o is TinkerTools )
				{
					if ( TinkerTools > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						TinkerTools = ( TinkerTools + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						return true;
					}
				}
				if ( o is ScribesPen )
				{
					if ( ScribesPen > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						ScribesPen = ( ScribesPen + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						return true;
					}
				}
				if ( o is MapmakersPen )
				{
					if ( MapmakersPen > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						MapmakersPen = ( MapmakersPen + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						return true;
					}
				}
				if ( o is SewingKit || o is SturdySewingKit )
				{
					if ( Sewing > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Sewing = ( Sewing + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						return true;
					}
				}
				if ( o is MalletAndChisel )
				{
					if ( MaletChisel > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						MaletChisel = ( MaletChisel + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						return true;
					}
				}
				if ( o is MarbleCraftingChisels )
				{
					if ( MarbleChisel > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						MarbleChisel = ( MarbleChisel + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						return true;
					}
				}
				if ( o is FletcherTools )
				{
					if ( Fletcher > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Fletcher = ( Fletcher + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						return true;
					}
				}
				if ( o is MortarPestle )
				{
					if ( Mortar > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Mortar = ( Mortar + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						return true;
					}
				}
				if ( o is Blowpipe )
				{
					if ( Blowpipe > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Blowpipe = ( Blowpipe + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						return true;
					}
				}
				if ( o is Skillet )
				{
					if ( Skillet > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Skillet = ( Skillet + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						return true;
					}
				}
				return false;
				//end drag drop
			}
			return false;
		}


		public void BeginCombine( Mobile from )
		{
			from.Target = new ToolBoxTarget( this );
		}

		public void EndCombine( Mobile from, object o )
		{
			if ( o is Item /*&& ((Item)o).IsChildOf( from.Backpack ) */)
			{
				if (!( o is BaseTool || o is BaseAxe || o is BaseHarvestTool || o is IngotTransmutationHammer || o is BoardTransmutationPlane ))
				{
					from.SendMessage( "That is not an item you can put in here." );
				}

				if ( o is SmithHammer || o is SturdySmithHammer )
				{
					if ( SmithHammer > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						SmithHammer = ( SmithHammer + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						from.SendGump( new ToolBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is Tongs )
				{
					if ( Tongs > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Tongs = ( Tongs + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						from.SendGump( new ToolBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is Shovel || o is SturdyShovel )
				{
					if ( Shovel > (999999 - ((BaseHarvestTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Shovel = ( Shovel + ((BaseHarvestTool)o).UsesRemaining );
						((Item)o).Delete();
						from.SendGump( new ToolBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is GargoylesPickaxe )
				{
					if ( Gargoyles > (999999 - ((BaseAxe)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Gargoyles = ( Gargoyles + ((BaseAxe)o).UsesRemaining );
						((Item)o).Delete();
						from.SendGump( new ToolBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is Pickaxe || o is SturdyPickaxe )
				{
					if ( Pickaxe > (999999 - ((BaseAxe)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Pickaxe = ( Pickaxe + ((BaseAxe)o).UsesRemaining );
						((Item)o).Delete();
						from.SendGump( new ToolBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is IngotTransmutationHammer )
				{
					if ( IngotHammer > (999999 - ((IngotTransmutationHammer)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						IngotHammer = ( IngotHammer + ((IngotTransmutationHammer)o).UsesRemaining );
						((Item)o).Delete();
						from.SendGump( new ToolBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is Hatchet || o is SturdyLumberjackAxe || o is SturdyAxe )
				{
					if ( Hatchet > (999999 - ((BaseAxe)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Hatchet = ( Hatchet + ((BaseAxe)o).UsesRemaining );
						((Item)o).Delete();
						from.SendGump( new ToolBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is TrollsHatchet )
				{
					if ( Trolls > (999999 - ((BaseAxe)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Trolls = ( Trolls + ((BaseAxe)o).UsesRemaining );
						((Item)o).Delete();
						from.SendGump( new ToolBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is Saw || o is DovetailSaw || o is DrawKnife || o is Froe || o is Hammer || o is Inshave || o is JointingPlane
                || o is MouldingPlane || o is Nails || o is Scorp )
				{
					if ( Plane > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Plane = ( Plane + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						from.SendGump( new ToolBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is BoardTransmutationPlane )
				{
					if ( BoardPlane > (999999 - ((BoardTransmutationPlane)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						BoardPlane = ( BoardPlane + ((BoardTransmutationPlane)o).UsesRemaining );
						((Item)o).Delete();
						from.SendGump( new ToolBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is TinkerTools )
				{
					if ( TinkerTools > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						TinkerTools = ( TinkerTools + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						from.SendGump( new ToolBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is ScribesPen )
				{
					if ( ScribesPen > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						ScribesPen = ( ScribesPen + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						from.SendGump( new ToolBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is MapmakersPen )
				{
					if ( MapmakersPen > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						MapmakersPen = ( MapmakersPen + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						from.SendGump( new ToolBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is SewingKit || o is SturdySewingKit )
				{
					if ( Sewing > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Sewing = ( Sewing + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						from.SendGump( new ToolBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is MalletAndChisel )
				{
					if ( MaletChisel > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						MaletChisel = ( MaletChisel + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						from.SendGump( new ToolBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is MarbleCraftingChisels )
				{
					if ( MarbleChisel > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						MarbleChisel = ( MarbleChisel + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						from.SendGump( new ToolBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is FletcherTools )
				{
					if ( Fletcher > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Fletcher = ( Fletcher + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						from.SendGump( new ToolBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is MortarPestle )
				{
					if ( Mortar > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Mortar = ( Mortar + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						from.SendGump( new ToolBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is Blowpipe )
				{
					if ( Blowpipe > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Blowpipe = ( Blowpipe + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						from.SendGump( new ToolBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
				if ( o is Skillet )
				{
					if ( Skillet > (999999 - ((BaseTool)o).UsesRemaining) )
						from.SendMessage( "That tool type is too full to add more." );
					else
					{
						Skillet = ( Skillet + ((BaseTool)o).UsesRemaining );
						((Item)o).Delete();
						from.SendGump( new ToolBoxGump( (PlayerMobile)from, this ) );
						BeginCombine( from );
					}
				}
			}
			else
			{
				from.SendLocalizedMessage( 1045158 ); // You must have the item in your backpack to target it.
			}
		}

		public ToolBox( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 1 ); // version
			writer.Write( (int) m_SmithHammer);
			writer.Write( (int) m_Tongs);
			writer.Write( (int) m_Shovel);
			writer.Write( (int) m_Gargoyles);
			writer.Write( (int) m_Pickaxe);
			writer.Write( (int) m_IngotHammer);
			writer.Write( (int) m_Hatchet);
			writer.Write( (int) m_Trolls);
			writer.Write( (int) m_Plane);
			writer.Write( (int) m_BoardPlane);
			writer.Write( (int) m_TinkerTools);
			writer.Write( (int) m_ScribesPen);
			writer.Write( (int) m_MapmakersPen);
			writer.Write( (int) m_Sewing);
			writer.Write( (int) m_MaletChisel);
			writer.Write( (int) m_MarbleChisel);
			writer.Write( (int) m_Fletcher);
			writer.Write( (int) m_Mortar);
			writer.Write( (int) m_Blowpipe);
			writer.Write( (int) m_Skillet);
		}
		
		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
			m_SmithHammer = reader.ReadInt();
			m_Tongs = reader.ReadInt();
			m_Shovel = reader.ReadInt();
			m_Gargoyles = reader.ReadInt();
			m_Pickaxe = reader.ReadInt();
			m_IngotHammer = reader.ReadInt();
			m_Hatchet = reader.ReadInt();
			m_Trolls = reader.ReadInt();
			m_Plane = reader.ReadInt();
			m_BoardPlane = reader.ReadInt();
			m_TinkerTools = reader.ReadInt();
			m_ScribesPen = reader.ReadInt();
			m_MapmakersPen = reader.ReadInt();
			m_Sewing = reader.ReadInt();
			m_MaletChisel = reader.ReadInt();
			m_MarbleChisel = reader.ReadInt();
			m_Fletcher = reader.ReadInt();
			m_Mortar = reader.ReadInt();
			m_Blowpipe = reader.ReadInt();
			m_Skillet = reader.ReadInt();
			
			if ( version == 0 )
			{
            m_Plane += m_BoardPlane;
            m_BoardPlane = 0;
         }
		}
	}
}


namespace Server.Items
{
	public class ToolBoxGump : Gump
	{
		private PlayerMobile m_From;
		private ToolBox m_Box;

		public ToolBoxGump( PlayerMobile from, ToolBox box ) : base( 25, 25 )
		{
			m_From = from;
			m_Box = box;

			m_From.CloseGump( typeof( ToolBoxGump ) );

			AddPage( 0 );

			AddBackground( 12, 19, 486, 315, 9250);
			AddLabel( 200, 30, 32, @"Tool Box");
			
			AddLabel( 60, 50, 32, @"Add Item");
			AddButton( 25, 50, 4005, 4007, 1, GumpButtonType.Reply, 0);

			AddLabel( 60, 75, 32, @"Close");
			AddButton( 25, 75, 4005, 4007, 0, GumpButtonType.Reply, 0);
			
			AddLabel( 60, 115, 6, @"Smith Hammer");
			AddLabel( 170, 115, 0x480, box.SmithHammer.ToString() );
			AddButton( 25, 115, 4005, 4007, 3, GumpButtonType.Reply, 0);
			
			AddLabel( 60, 135, 6, @"Tongs");
			AddLabel( 170, 135, 0x480, box.Tongs.ToString() );
			AddButton( 25, 135, 4005, 4007, 4, GumpButtonType.Reply, 0);
			
			AddLabel( 60, 155, 1149, @"Shovel");
			AddLabel( 170, 155, 0x480, box.Shovel.ToString() );
			AddButton( 25, 155, 4005, 4007, 5, GumpButtonType.Reply, 0);
			
			AddLabel( 60, 175, 1149, @"Garg. Pickaxe");
			AddLabel( 170, 175, 0x480, box.Gargoyles.ToString() );
			AddButton( 25, 175, 4005, 4007, 6, GumpButtonType.Reply, 0);
			
			AddLabel( 60, 195, 1149, @"Pickaxe");
			AddLabel(  170, 195, 0x480, box.Pickaxe.ToString() );
			AddButton(  25, 195, 4005, 4007, 7, GumpButtonType.Reply, 0 );
			
			AddLabel( 60, 215, 1149, @"Ingot Hammer");
			AddLabel(  170, 215, 0x480, box.IngotHammer.ToString() );
			AddButton(  25, 215, 4005, 4007, 8, GumpButtonType.Reply, 0 );
			
			AddLabel( 60, 235, 2206, @"Hatchet");
			AddLabel(  170, 235, 0x480, box.Hatchet.ToString() );
			AddButton(  25, 235, 4005, 4007, 9, GumpButtonType.Reply, 0 );
			
			AddLabel( 60, 255, 2206, @"Troll's Axe");
			AddLabel(  170, 255, 0x480, box.Trolls.ToString() );
			AddButton(  25, 255, 4005, 4007, 20, GumpButtonType.Reply, 0 );

			AddLabel( 60, 275, 2418, @"Jointing Plane");
			AddLabel(  170, 275, 0x480, box.Plane.ToString() );
			AddButton(  25, 275, 4005, 4007, 21, GumpButtonType.Reply, 0 );

			AddLabel( 60, 295, 2418, @"Board Plane");
			AddLabel(  170, 295, 0x480, box.BoardPlane.ToString() );
			AddButton(  25, 295, 4005, 4007, 22, GumpButtonType.Reply, 0 );
			
			AddLabel( 320, 115, 2218, @"Tinker Tools" );
			AddLabel( 430, 115, 0x480, box.TinkerTools.ToString() );
			AddButton( 285, 115, 4005, 4007, 10, GumpButtonType.Reply, 0 );
			
			AddLabel(320, 135, 1359, @"Scribe's Pen");
			AddLabel( 430, 135, 0x480, box.ScribesPen.ToString() );
			AddButton(285, 135, 4005, 4007, 11, GumpButtonType.Reply, 0);
			
			AddLabel(320, 155, 1359, @"Mapmaker's Pen");
			AddLabel( 430, 155, 0x480, box.MapmakersPen.ToString() );
			AddButton(285, 155, 4005, 4007, 12, GumpButtonType.Reply, 0);
			
			AddLabel(320, 175, 1171, @"Sewing Kit");
			AddLabel( 430, 175, 0x480, box.Sewing.ToString() );
			AddButton(285, 175, 4005, 4007, 13, GumpButtonType.Reply, 0);
			
			AddLabel(320, 195, 2417, @"Malet & Chisel");
			AddLabel( 430, 195, 0x480, box.MaletChisel.ToString() );
			AddButton(285, 195, 4005, 4007, 14, GumpButtonType.Reply, 0);
			
			AddLabel(320, 215, 2417, @"Marble Chisel");
			AddLabel( 430, 215, 0x480, box.MarbleChisel.ToString() );
			AddButton(285, 215, 4005, 4007, 15, GumpButtonType.Reply, 0);
			
			AddLabel(320, 235, 2424, @"Fletcher Tools");
			AddLabel( 430, 235, 0x480, box.Fletcher.ToString() );
			AddButton(285, 235, 4005, 4007, 16, GumpButtonType.Reply, 0);

			AddLabel(320, 255, 1157, @"Mortar & Pestle");
			AddLabel( 430, 255, 0x480, box.Mortar.ToString() );
			AddButton(285, 255, 4005, 4007, 23, GumpButtonType.Reply, 0);

			AddLabel(320, 275, 1108, @"Blowpipe");
			AddLabel( 430, 275, 0x480, box.Blowpipe.ToString() );
			AddButton(285, 275, 4005, 4007, 24, GumpButtonType.Reply, 0);

			AddLabel(320, 295, 1163, @"Skillet");
			AddLabel( 430, 295, 0x480, box.Skillet.ToString() );
			AddButton(285, 295, 4005, 4007, 25, GumpButtonType.Reply, 0);
		}

		public override void OnResponse( NetState sender, RelayInfo info )
		{
			if ( m_Box.Deleted )
				return;
		   else if ( !m_From.InRange( m_Box.GetWorldLocation(), 5 ) )
			{
            m_From.SendMessage( "Jsi od {0} prilis daleko!", m_Box.Name );            
			   if( m_From.HasGump( typeof(ToolBoxGump) ) )
				  m_From.CloseGump( typeof(ToolBoxGump) );
				return;
         }
         
			if ( info.ButtonID == 1)
			{
				m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
				m_Box.BeginCombine( m_From );
			}
			
			if ( info.ButtonID == 3 )
			{
				if ( m_Box.SmithHammer > 0 )
				{
					m_From.AddToBackpack( new SmithHammer(m_Box.SmithHammer) );
					m_Box.SmithHammer = ( 0 );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
				}
				else
				{
					m_From.SendMessage( "You do not have any of that item!" );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
					m_Box.BeginCombine( m_From );
				}
			}
			if ( info.ButtonID == 4 )
			{
				if ( m_Box.Tongs > 0 )
				{
					m_From.AddToBackpack( new Tongs(m_Box.Tongs) );
					m_Box.Tongs = ( 0 );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
				}
				else
				{
					m_From.SendMessage( "You do not have any of that item!" );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
					m_Box.BeginCombine( m_From );
				}
			}
			if ( info.ButtonID == 5 )
			{
				if ( m_Box.Shovel > 0 )
				{
					m_From.AddToBackpack( new Shovel(m_Box.Shovel) );
					m_Box.Shovel = ( 0 );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
				}
				else
				{
					m_From.SendMessage( "You do not have any of that item!" );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
					m_Box.BeginCombine( m_From );
				}
			}
			if ( info.ButtonID == 6 )
			{
				if ( m_Box.Gargoyles > 0 )
				{
					m_From.AddToBackpack( new GargoylesPickaxe(m_Box.Gargoyles) );
					m_Box.Gargoyles = ( 0 );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
				}
				else
				{
					m_From.SendMessage( "You do not have any of that item!" );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
					m_Box.BeginCombine( m_From );
				}
			}
			if ( info.ButtonID == 7 )
			{
				if ( m_Box.Pickaxe > 0 )
				{
					BaseAxe item = new Pickaxe();
					item.UsesRemaining = m_Box.Pickaxe;
					m_From.AddToBackpack( item );
					m_Box.Pickaxe = ( 0 );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
				}
				else
				{
					m_From.SendMessage( "You do not have any of that item!" );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
					m_Box.BeginCombine( m_From );
				}
			}
			if ( info.ButtonID == 8 )
			{
				if ( m_Box.IngotHammer > 0 )
				{
					IngotTransmutationHammer item = new IngotTransmutationHammer();
					item.UsesRemaining = m_Box.IngotHammer;
					m_From.AddToBackpack( item );
					m_Box.IngotHammer = ( 0 );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
				}
				else
				{
					m_From.SendMessage( "You do not have any of that item!" );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
					m_Box.BeginCombine( m_From );
				}
			}
			if ( info.ButtonID == 9 )
			{
				if ( m_Box.Hatchet > 0 )
				{
					BaseAxe item = new Hatchet();
					item.UsesRemaining = m_Box.Hatchet;
					item.ShowUsesRemaining = true;
					m_From.AddToBackpack( item );
					m_Box.Hatchet = ( 0 );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
				}
				else
				{
					m_From.SendMessage( "You do not have any of that item!" );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
					m_Box.BeginCombine( m_From );
				}
			}
			if ( info.ButtonID == 20 )
			{
				if ( m_Box.Trolls > 0 )
				{
					BaseAxe item = new TrollsHatchet();
					item.UsesRemaining = m_Box.Trolls;
					item.ShowUsesRemaining = true;
					m_From.AddToBackpack( item );
					m_Box.Trolls = ( 0 );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
				}
				else
				{
					m_From.SendMessage( "You do not have any of that item!" );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
					m_Box.BeginCombine( m_From );
				}
			}
			if ( info.ButtonID == 21 )
			{
				if ( m_Box.Plane > 0 )
				{
					m_From.AddToBackpack( new JointingPlane(m_Box.Plane) );
					m_Box.Plane = ( 0 );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
				}
				else
				{
					m_From.SendMessage( "You do not have any of that item!" );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
					m_Box.BeginCombine( m_From );
				}
			}
			if ( info.ButtonID == 22 )
			{
				if ( m_Box.BoardPlane > 0 )
				{
					m_From.AddToBackpack( new BoardTransmutationPlane(m_Box.BoardPlane) );
					m_Box.BoardPlane = ( 0 );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
				}
				else
				{
					m_From.SendMessage( "You do not have any of that item!" );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
					m_Box.BeginCombine( m_From );
				}
			}
			if ( info.ButtonID == 10 )
			{
				if ( m_Box.TinkerTools > 0 )
				{
					m_From.AddToBackpack( new TinkerTools(m_Box.TinkerTools) );
					m_Box.TinkerTools = ( 0 );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
				}
				else
				{
					m_From.SendMessage( "You do not have any of that item!" );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
					m_Box.BeginCombine( m_From );
				}
			}
			if ( info.ButtonID == 11 )
			{
				if ( m_Box.ScribesPen > 0 )
				{
					m_From.AddToBackpack( new ScribesPen(m_Box.ScribesPen) );
					m_Box.ScribesPen = ( 0 );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
				}
				else
				{
					m_From.SendMessage( "You do not have any of that item!" );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
					m_Box.BeginCombine( m_From );
				}
			}
			if ( info.ButtonID == 12 )
			{
				if ( m_Box.MapmakersPen > 0 )
				{
					m_From.AddToBackpack( new MapmakersPen(m_Box.MapmakersPen) );
					m_Box.MapmakersPen = ( 0 );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
				}
				else
				{
					m_From.SendMessage( "You do not have any of that item!" );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
					m_Box.BeginCombine( m_From );
				}
			}
			if ( info.ButtonID == 13 )
			{
				if ( m_Box.Sewing > 0 )
				{
					m_From.AddToBackpack( new SewingKit(m_Box.Sewing) );
					m_Box.Sewing = ( 0 );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
				}
				else
				{
					m_From.SendMessage( "You do not have any of that item!" );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
					m_Box.BeginCombine( m_From );
				}
			}
			if ( info.ButtonID == 14 )
			{
				if ( m_Box.MaletChisel > 0 )
				{
					m_From.AddToBackpack( new MalletAndChisel(m_Box.MaletChisel) );
					m_Box.MaletChisel = ( 0 );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
				}
				else
				{
					m_From.SendMessage( "You do not have any of that item!" );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
					m_Box.BeginCombine( m_From );
				}
			}
			if ( info.ButtonID == 15 )
			{
				if ( m_Box.MarbleChisel > 0 )
				{
					m_From.AddToBackpack( new MarbleCraftingChisels(m_Box.MarbleChisel) );
					m_Box.MarbleChisel = ( 0 );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
				}
				else
				{
					m_From.SendMessage( "You do not have any of that item!" );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
					m_Box.BeginCombine( m_From );
				}
			}
			if ( info.ButtonID == 16 )
			{
				if ( m_Box.Fletcher > 0 )
				{
					m_From.AddToBackpack( new FletcherTools(m_Box.Fletcher) );
					m_Box.Fletcher = ( 0 );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
				}
				else
				{
					m_From.SendMessage( "You do not have any of that item!" );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
					m_Box.BeginCombine( m_From );
				}
			}
			if ( info.ButtonID == 23 )
			{
				if ( m_Box.Mortar > 0 )
				{
					m_From.AddToBackpack( new MortarPestle(m_Box.Mortar) );
					m_Box.Mortar = ( 0 );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
				}
				else
				{
					m_From.SendMessage( "You do not have any of that item!" );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
					m_Box.BeginCombine( m_From );
				}
			}
			if ( info.ButtonID == 24 )
			{
				if ( m_Box.Blowpipe > 0 )
				{
					m_From.AddToBackpack( new Blowpipe(m_Box.Blowpipe) );
					m_Box.Blowpipe = ( 0 );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
				}
				else
				{
					m_From.SendMessage( "You do not have any of that item!" );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
					m_Box.BeginCombine( m_From );
				}
			}
			if ( info.ButtonID == 25 )
			{
				if ( m_Box.Skillet > 0 )
				{
					m_From.AddToBackpack( new Skillet(m_Box.Skillet) );
					m_Box.Skillet = ( 0 );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
				}
				else
				{
					m_From.SendMessage( "You do not have any of that item!" );
					m_From.SendGump( new ToolBoxGump( m_From, m_Box ) );
					m_Box.BeginCombine( m_From );
				}
			}
		}
	}
}

namespace Server.Items
{
	public class ToolBoxTarget : Target
	{
		private ToolBox m_Box;

		public ToolBoxTarget( ToolBox box ) : base( 18, false, TargetFlags.None )
		{
			m_Box = box;
		}

		protected override void OnTarget( Mobile from, object targeted )
		{
			if ( m_Box.Deleted )
				return;
			else if ( !from.InRange( m_Box.GetWorldLocation(), 5 ) )
			{
            from.SendMessage( "Jsi od {0} prilis daleko!", m_Box.Name );            
			   if( from.HasGump( typeof(ToolBoxGump) ) )
				  from.CloseGump( typeof(ToolBoxGump) );
				return;
         }
			else if ( targeted is Item && !from.InRange( ((Item)targeted).GetWorldLocation(), 2 ) )
			{
            from.SendMessage( "Jsi od {0} prilis daleko!", ((Item)targeted).Name );
				return;
         }
         
			m_Box.EndCombine( from, targeted );
		}
	}
}
